#ifndef MCAT_OUTPUT_TCP_HPP
#define MCAT_OUTPUT_TCP_HPP

#include "output.hpp"

namespace mcat
{

class OutputTCP : public Output
{
public:
    /**
     * Construtor that open the connection to the destination stream
     * @param mrl: the MRL of the destination stream
     */
    OutputTCP(Mrl &mrl);

    /** Destructor */
    virtual ~OutputTCP();

    /**
     * Write to the destination
     * @param p_buffer: the buffer to write
     * @param ui_size: the size of the buffer to write
     * @return the size writen to the destination
     */
    virtual int write(const char *p_buffer, ssize_t ui_size);

    /**
     * Get the protocol used to analyse the command line
     * @return the protocol
     */
    inline static const char* getProtocol()
    {
        return "tcp";
    }

    /**
     * Get the usage as printed in the ./mc --help command
     * @return the usage
     */
    inline static const char* getUsage()
    {
        return "open a socket and send to the client via tcp";
    }

protected:
    /** Server socket */
    int i_socket_fd;

    /** Socket defined after a call to accept() */
    int i_cl_socket_fd;

    /** Structure containing the inet socket address */
    struct addrinfo* p_addr_info;
};

};

#endif // MCAT_OUTPUT_TCP_HPP
