#ifndef MCAT_INPUT_TCP_HPP
#define MCAT_INPUT_TCP_HPP

#include <netinet/in.h>

#include "input.hpp"

namespace mcat
{

class InputTCP : public Input
{
public:
    /**
     * Construtor that open the connection to the source stream
     * @param mrl: the MRL of the source stream
     */
    InputTCP(Mrl &mrl);

    /** Destructor */
    virtual ~InputTCP();

    /**
     * Read from the source
     * @param p_buffer: the buffer to fill
     * @param ui_size: the size of the buffer to read
     * @return the size read from the source
     */
    virtual int read(char *p_buffer, ssize_t ui_size);

    /**
     * Get the protocol used to analyse the command line
     * @return the protocol
     */
    inline static const char* getProtocol()
    {
        return "tcp";
    }

    /**
     * Get the usage as printed in the ./mc --help command
     * @return the usage
     */
    inline static const char* getUsage()
    {
        return "connect to a remote tcp socket and read from it";
    }

protected:
    /** Input socket */
    int i_socket_fd;

    /** Structure containing the inet socket address */
    struct addrinfo* p_addr_info;
};

};

#endif // MCAT_INPUT_TCP_HPP
