#ifndef MCAT_COMMON_HPP
#define MCAT_COMMON_HPP

#include <netdb.h>
#include "mrl.hpp"

namespace mcat
{

/**
 * Get address info
 * @param mrl: the mrl
 * @param family: the protocol family of the socket
 * @param socket_type: the type of the socket
 * @param pp_addr_info: the result (must be deallocated by freeaddrinfo)
 * @return false in case of failure
 */
bool getAddressInfo(Mrl &mrl, int family, int socket_type, addrinfo **pp_addr_info);

/**
 * Enables the broadcast on the given socket (udp only)
 * @param sock socket to configure
 * @return true if success
 */
bool enableBroadcast(int sock);

};

#endif // MCAT_COMMON_HPP
