#include <iostream>
#include <netdb.h>
#include <sys/socket.h>
#include <cstring>
#include <cstdlib>

#include "common.hpp"

namespace mcat
{

bool getAddressInfo(Mrl &mrl, int family, int socket_type, addrinfo **pp_addr_info)
{
    int error;
    addrinfo hints;
    const char *hostname = mrl.getHostname();

    // Configure the type of socket wanted
    memset(&hints, 0, sizeof(hints));
    hints.ai_family = family;
    hints.ai_socktype = socket_type;

    if((error = getaddrinfo(hostname, mrl.getPort(), &hints, pp_addr_info) != 0))
    {
        std::cerr << "getaddrinfo() on " << hostname
                  << "failed: " << strerror(error) << std::endl;
        return false;
    }

    return true;
}

bool enableBroadcast(int sock)
{
    int flag_true = 1;
    if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST,
                      (void*)&flag_true, sizeof(flag_true)) < 0)
    {
        std::cerr << "Setting up broadcast failed" << std::endl;
        return false;
    }
    return true;
}

}

