#include <assert.h>
#include <cstring>
#include <iostream>

#include "ring_buffer.hpp"


using namespace std;
using namespace mcat;

void test_memory_allocation()
{
    RingBuffer *ringbuffer = new RingBuffer(1,1);
    delete ringbuffer;
    ringbuffer = new RingBuffer(1,10000);
    delete ringbuffer;
    ringbuffer = new RingBuffer(10000,1);
    delete ringbuffer;
    ringbuffer = new RingBuffer(1000,1000);
    delete ringbuffer;
    ringbuffer = new RingBuffer(10000,10000);
    delete ringbuffer;
    ringbuffer = new RingBuffer(1000,100000);
    delete ringbuffer;
    ringbuffer = new RingBuffer(1,1000000);
    delete ringbuffer;
}

void test_usage(size_t size, unsigned int count)
{
    RingBuffer ringbuffer(size, count);
    Buffer *p_buffer;

    for(int i = 0; i < 5; i++)
    {
        for(unsigned int j = 0; j < count; j++)
        {
            p_buffer = ringbuffer.nextEmpty();
            assert(p_buffer->i_size == size);
            assert(p_buffer->p_buffer);
            ringbuffer.pushFull(p_buffer);
        }

        for(unsigned int j = 0; j < count; j++)
        {
            (void)ringbuffer.nextFull();
            ringbuffer.popFull();
        }
    }
}

int main()
{
    cout << "Test the ring buffer class...";
    cout.flush();
    test_memory_allocation();
    test_usage(1,10);
    test_usage(10,100);
    cout << "\t[done]" << endl;
}
