#include <cstring>
#include <iostream>
#include <sstream>

#include "input_file.hpp"
#include "mrl.hpp"

#include "test_inout.hpp"

using namespace std;
using namespace mcat;

int main()
{
    char big_buf[BUF_LEN + 2];
    char *buf = big_buf + 1;
    cout << "Test the InputFile class...";
    cout.flush();

    for(size_t i = 0; i < file_names_count; i++)
    {
        for(size_t j = 0; j < samples_count; j++)
        {
            // Create the file
            ofstream src(file_names[i]);
            src.write(samples[j].in, samples[j].len);
            src.close();

            // Create the input file
            Mrl mrl(string("file://") + string(file_names[i]));
            InputFile inf(mrl);

            memset(big_buf, 0, sizeof(big_buf));
            inf.read(buf, samples[j].len);
            if(big_buf[0] != '\0')
            {
                cerr << endl << "InputFile::read(\"" << samples[j].in << "\", "
                     << samples[j].len << ") failed "
                    << "the program has written before the buffer"
                    << endl;
                return 1;
            }

            if(buf[samples[j].len] != '\0')
            {
                cerr << endl << "InputFile::read(\"" << samples[j].in << "\", "
                     << samples[j].len << ") failed "
                    << "the program has written after the buffer"
                    << endl;
                return 1;
            }

            if(memcmp(buf, samples[j].out, samples[j].len))
            {
                cerr << endl << "InputFile::read(\"" << samples[j].in << "\", "
                    << samples[j].len << ") failed got `" << buf
                    << "` instead of " << samples[j].out
                    << endl;
                return 1;
            }
            remove(file_names[i]);
        }
    }
    cout << "\t[done]" << endl;
}

