#ifndef MCAT_TEST_INPUT_HPP
#define MCAT_TEST_INPUT_HPP
namespace mcat
{
#define BUF_LEN 5

typedef struct
{
    const char *in;
    const char *out;
    size_t len;
} sample_t;

static const sample_t samples[] =
{
    {"",        "",      1},
    {"1",       "1",     2},
    {"1234",    "1234",  BUF_LEN},
    {"12345",   "12345", BUF_LEN},
    {"1234567", "12345", BUF_LEN},
    {"é",       "é",     3},
};
static const size_t samples_count = sizeof(samples)/sizeof(samples[0]);

static const char *file_names[] =
{
    "azertyuiop",
    "/tmp/erztyukjh",
    "&é\"'(-",
    "1234567890poiuyj,nbvcrftyuiok",
};
static const size_t file_names_count = sizeof(file_names)/sizeof(file_names[0]);

static const char *urls[] =
{
    "127.0.0.1",
    "localhost:4211",
    "127.0.0.1:65535",
    "[::1]:12345",
};
static const size_t urls_count = sizeof(urls)/sizeof(urls[0]);

typedef struct
{
    const char* url;
    const sample_t* sample;
} net_test_t;

};

#endif // MCAT_TEST_INPUT_HPP
