#ifndef MCAT_RING_BUFFER_HPP
#define MCAT_RING_BUFFER_HPP

#include <queue>
#include <vector>

#include <pthread.h>

#include "buffer.hpp"

namespace mcat
{

class RingBuffer
{
public:
    /**
     * Constructor
     * @param buffer_size: size of each buffer
     * @param buffer_count: number of buffer
     */
    RingBuffer(size_t buffer_size, unsigned int buffer_count);

    /** Destructor */
    ~RingBuffer();

    /**
     * Get a pointer to the next full buffer
     * @return the next full buffer
     */
    const Buffer *nextFull();

    /**
     * Signal that one buffer is now empty
     */
    void popFull();

    /**
     * Get an empty buffer
     * @return an empty buffer
     */
    Buffer *nextEmpty();

    /**
     * Add a new full buffer
     * @param p_buffer: the new buffer
     */
    void pushFull(Buffer *p_buffer);


protected:
    /** The mutex that protect everything */
    pthread_mutex_t m_lock;

    /** Condition variable */
    pthread_cond_t m_cond;

    /** The buffers */
    std::queue<Buffer*> m_buffer;

    /** Free buffers */
    std::queue<Buffer*> m_free_buffer;

    /** Size of the buffers */
    size_t m_buffer_size;

    /** Number of buffers */
    unsigned int m_buffer_count;
};

};

#endif // MCAT_RING_BUFFER_HPP
