#ifndef MCAT_OUTPUT_HPP
#define MCAT_OUTPUT_HPP

#include "mrl.hpp"

namespace mcat
{

class Output
{
public:
    /**
     * Construtor that open the connection to the destination stream
     * @param mrl: the MRL of the destination stream
     */
    Output(Mrl &mrl) : m_mrl(mrl), is_ready(false) {}

    /** Destructor */
    virtual ~Output() {}

    /**
     * Write to the destination
     * @param p_buffer: the buffer to write
     * @param ui_size: the size of the buffer to write
     * @return the size written to the destination
     */
    virtual int write(const char *p_buffer, ssize_t ui_size) = 0;

    /**
     * Is the Input ready to be used ?
     */
    bool ready() { return is_ready; }

protected:
    /** Mrl of the output */
    Mrl m_mrl;

    /** True if the output is ready to be used, false overwise */
    bool is_ready;
};

};

#endif // MCAT_OUTPUT_HPP
