#ifndef MCAT_MRL_HPP
#define MCAT_MRL_HPP

#include <string>

namespace mcat
{

class Mrl
{
public:
    /**
     * Construtor that parse the mrl
     * @param mrl: the MRL to parse
     */
    Mrl(std::string mrl);

    /**
     * Get the protocol
     * @return the protocol
     */
    const char *getProtocol() { return m_protocol.c_str(); }

    /**
     * Get the hostname of the mrl
     * @return the hostname
     */
    const char *getHostname() { return m_hostname.c_str(); }

    /**
     * Get the port number of the mrl
     * @return the port number
     */
    const char *getPort() { return m_port.c_str(); }

    /**
     * Get the path of the mrl
     * @return the path
     */
    const char *getPath() { return m_path.c_str(); }

protected:
    /** The protocol (udp, file, std,  ...) */
    std::string m_protocol;

    /** The hostname if any */
    std::string m_hostname;

    /** The port if any */
    std::string m_port;

    /** The path to the device/file if any */
    std::string m_path;
};

};

#endif // MCAT_INPUT_HPP
