#include <arpa/inet.h>
#include <cstdlib>
#include <netdb.h>

#include "mrl.hpp"

using namespace mcat;

// TODO: find a better default value
#define DEFAULT_PORT "4212"

/**
 * Constructor that parse the mr
 * The mrl look like: proto://[hostname[:port]][path]
 * If the protocol is missing, this will be interpreted as a file
 * @param mrl: the mrl to parse
 */
Mrl::Mrl(std::string mrl)
{
    // Get the protocol
    size_t proto = mrl.find("://");
    if(proto == std::string::npos)
        m_protocol = "file";
    else
        m_protocol = mrl.substr(0, proto);

    // If this is a file or the standard input/output
    if(m_protocol == "file" || m_protocol == "std")
    {
        m_hostname = "";
        m_port = "";
        if(proto == std::string::npos)
            m_path = mrl;
        else
            m_path = mrl.substr(proto + 3);
    }
    // Get the hostname and the port
    else
    {
        //if begins with '[' => ipv6 [xyz:...:t]:port
        //                           [xyz:...:t]
        //else               => ipv4  x.y.z.t:port
        m_path = "";
        if (mrl[proto+3] == '[') //ipv6
        {
            size_t end_ip6 = mrl.find(']', proto+3);
            size_t port = mrl.find(':', end_ip6 + 1);
            m_hostname = mrl.substr(proto+4, end_ip6 - proto - 4);
            if(port == std::string::npos)
            {
                m_port = DEFAULT_PORT;
            }
            else
            {
                m_port = mrl.substr(port + 1);
            }
        }
        else //ipv4
        {
            size_t port = mrl.find(':', proto + 1);
            if(port == std::string::npos)
            {
                m_hostname = mrl.substr(proto + 3);
                m_port = DEFAULT_PORT;
            }
            else
            {
                m_hostname = mrl.substr(proto + 3, port - proto - 3);
                m_port = mrl.substr(port + 1);
            }
        }

    }
}

