#ifndef INPUT_UDP_HPP
#define INPUT_UDP_HPP

#include <netinet/in.h>

#include "input.hpp"

namespace mcat
{

class InputUDP : public Input
{
public:
    /**
     * Constructor which opens a connection form an UDP source
     * @param mrl: the MRL of the source stream
     * @param broadcast: whether input broadcast is allowed
     */
    InputUDP(Mrl &mrl, bool broadcast = false);

    /** Destructor */
    virtual ~InputUDP();

    /**
     * Read from the source
     * @param p_buffer: the buffer to fill
     * @param ui_size: the size of the buffer to read
     * @return the size read from the source
     */
    virtual int read(char* p_buffer, ssize_t ui_size);

    /**
     * Get the protocol used to analyse the command line
     * @return the protocol
     */
    inline static const char* getProtocol()
    {
        return "udp";
    }

    /**
     * Get the usage as printed in the ./mc --help command
     * @return the usage
     */
    inline static const char* getUsage()
    {
        return "read from an udp stream or connect to a multicast stream";
    }

protected:
    /** Input socket */
    int i_sock;
    /** Structure containing the inet socket address */
    struct addrinfo* p_addr_info;
};

}

#endif // INPUT_UDP_HPP
