#include <iostream>
#include <cstdlib>
#include <cstring>

#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "common.hpp"
#include "macros.hpp"
#include "input_tcp.hpp"

using namespace mcat;

InputTCP::InputTCP(Mrl &mrl) : Input(mrl)
{
    if(!getAddressInfo(mrl, AF_UNSPEC, SOCK_STREAM, &p_addr_info))
        return;

    // Create the socket
    i_socket_fd = socket(p_addr_info->ai_family == AF_INET ? PF_INET : PF_INET6,
                         SOCK_STREAM, IPPROTO_TCP);

    if(i_socket_fd < 0)
    {
        std::cerr << "Unable to create the socket" << std::endl;
        return;
    }

    // Connect to the stream
    if(connect(i_socket_fd, p_addr_info->ai_addr, p_addr_info->ai_addrlen) < 0)
    {
        std::cerr << "Unable to connect to the server" << std::endl;
        return;
    }

    // The input is now ready
    is_ready = true;
}

InputTCP::~InputTCP()
{
    // Close the socket
    close(i_socket_fd);
    freeaddrinfo(p_addr_info);
}

int InputTCP::read(char *p_buffer, ssize_t ui_size)
{
    return recv(i_socket_fd, p_buffer, ui_size, 0);
}

