#ifndef MCAT_INPUT_HPP
#define MCAT_INPUT_HPP

#include "mrl.hpp"

namespace mcat
{

class Input
{
public:
    /**
     * Construtor that open the connection to the source stream
     * @param mrl: the MRL of the source stream
     */
    Input(Mrl &mrl) : m_mrl(mrl), is_ready(false) { }

    /** Destructor */
    virtual ~Input() {}

    /**
     * Read from the source
     * @param p_buffer: the buffer to fill
     * @param ui_size: the size of the buffer to read
     * @return the size read from the source
     */
    virtual int read(char *p_buffer, ssize_t ui_size) = 0;

    /**
     * Is the Input ready to be used ?
     */
    bool ready() { return is_ready; }

protected:
    /** Mrl of the input */
    Mrl m_mrl;

    /** True if the input is ready to be used, false overwise */
    bool is_ready;
};

};

#endif // MCAT_INPUT_HPP
