#include <cstring>
#include <iostream>
#include <sstream>

#include "output_file.hpp"
#include "mrl.hpp"

#include "test_inout.hpp"

using namespace std;
using namespace mcat;

int main()
{
    char big_buf[BUF_LEN + 2];
    cout << "Test the OutputFile class...";
    cout.flush();

    for(size_t i = 0; i < file_names_count; i++)
    {
        for(size_t j = 0; j < samples_count; j++)
        {
            // Create the output file
            Mrl mrl(string("file://") + string(file_names[i]));
            OutputFile *outf = new OutputFile(mrl);
            outf->write(samples[j].in, samples[j].len);
            delete outf;

            // Read the file
            memset(big_buf, 0, sizeof(big_buf));
            ifstream inf(file_names[i]);
            inf.read(big_buf, samples[j].len);

            if(memcmp(big_buf, samples[j].out, samples[j].len))
            {
                cerr << endl << "OutputFile::read(\"" << samples[j].in << "\", "
                    << samples[j].len << ") failed got `" << big_buf
                    << "` instead of " << samples[j].out
                    << endl;
                return 1;
            }

            remove(file_names[i]);
        }
    }
    cout << "\t[done]" << endl;
}

