#include <cstring>
#include <iostream>

#include "mrl.hpp"


using namespace std;
using namespace mcat;

typedef struct
{
    const char *mrl;
    const char *protocol;
    const char *hostname;
    const char *port;
    const char *path;
}sample_t;

static const sample_t samples[] =
{
    {"",                        "file", "",                "",       "" },
    {"one_file",                "file", "",                "",       "one_file" },
    {"/accents/éàç€@",          "file", "",                "",       "/accents/éàç€@" },
    {"[1234::1345]",            "file", "",                "",       "[1234::1345]" },
    {"file://one_file",         "file", "",                "",       "one_file" },
    {"file://",                 "file", "",                "",       "" },
    {"file:///test/bla",        "file", "",                "",       "/test/bla" },
    {"file:///\"/",             "file", "",                "",       "/\"/" },
    {"file:///some/here/../dif","file", "",                "",       "/some/here/../dif" },
    {"file:///toto/©/m.txt",    "file", "",                "",       "/toto/©/m.txt" },
    {"file:///root/]/[/-/test", "file", "",                "",       "/root/]/[/-/test" },

    {"tcp://",                  "tcp",  "",                "4212",   "" },
    {"tcp://localhost",         "tcp",  "localhost",       "4212",   "" },
    {"tcp://dinauz.org",        "tcp",  "dinauz.org",      "4212",   "" },
    {"tcp://127.0.0.1",         "tcp",  "127.0.0.1",       "4212",   "" },
    {"tcp://255.255.255.255:42","tcp",  "255.255.255.255", "42",     "" },
    {"tcp://dinauz.org:5535",   "tcp",  "dinauz.org",      "5535",   "" },
    {"tcp://:4567",             "tcp",  "",                "4567",   "" },
    {"tcp://google.com:789100", "tcp",  "google.com",      "789100", "" },
    {"tcp://[::1]",             "tcp",  "::1",             "4212",   "" },
    {"tcp://[1fff:0a88::8001]", "tcp",  "1fff:0a88::8001", "4212",   "" },
    {"tcp://[::8001]:52",       "tcp",  "::8001",          "52",     "" },
    {"tcp://[0a88::8001]:52",   "tcp",  "0a88::8001",      "52",     "" },
    {"tcp://[::1]",             "tcp",  "::1",             "4212",   "" },

    {"udp://",                  "udp",  "",                "4212",   "" },
    {"udp://localhost",         "udp",  "localhost",       "4212",   "" },
    {"udp://localhost:1",       "udp",  "localhost",       "1",      "" },
    {"udp://[::1]:1234",        "udp",  "::1",             "1234",   "" },
    {"udp://[::1]:[1234",       "udp",  "::1",             "[1234",  "" },
    {"udp://[1234:1234::1]:123","udp",  "1234:1234::1",    "123",    "" },
    {"udp://127.0.0.1",         "udp",  "127.0.0.1",       "4212",   "" },
    {"udp://127.0.0.1:1234",    "udp",  "127.0.0.1",       "1234",   "" },
    {"udp://239.0.25.1:654312", "udp",  "239.0.25.1",      "654312", "" },
    {"udp://localhost:65535",   "udp",  "localhost",       "65535",  "" },

    {"std://",                  "std",  "",                "",       "" },
    {"std://cerr",              "std",  "",                "",       "cerr" },
    {"std://123/431",           "std",  "",                "",       "123/431" },
    {"std://127.0.0.1:1234",    "std",  "",                "",       "127.0.0.1:1234" },
    {"std://[123:12::1]:1234",  "std",  "",                "",       "[123:12::1]:1234" },

};
static const size_t samples_count = sizeof(samples)/sizeof(sample_t);


int main()
{
    cout << "Test MRL class...";
    cout.flush();
    for(size_t i = 0; i < samples_count; i++)
    {
        // Parse the mrl
        Mrl mrl(samples[i].mrl);

        // Test the protocol
        if(strcmp(mrl.getProtocol(), samples[i].protocol))
        {
            cerr << endl << "mrl(" << samples[i].mrl << ").getProtocol() == "
                 << mrl.getProtocol() << " instead of " << samples[i].protocol
                 << endl;
            return 1;
        }
        // Test the hostname
        if(strcmp(mrl.getHostname(), samples[i].hostname))
        {
            cerr << endl << "mrl(" << samples[i].mrl << ").getHostname() == "
                 << mrl.getHostname() << " instead of " << samples[i].hostname
                 << endl;
            return 1;
        }
        // Test the port
        if(strcmp(mrl.getPort(), samples[i].port))
        {
            cerr << endl << "mrl(" << samples[i].mrl << ").getPort() == "
                 << mrl.getPort() << " instead of " << samples[i].port
                 << endl;
            return 1;
        }
        // Test the path
        if(strcmp(mrl.getPath(), samples[i].path))
        {
            cerr << endl << "mrl(" << samples[i].mrl << ").getPath() == "
                 << mrl.getPath() << " instead of " << samples[i].path
                 << endl;
            return 1;
        }
    }
    cout << "\t\t[done]" << endl;
}
