#include <cstring>
#include <iostream>
#include <sstream>

#include <pthread.h>
#include <semaphore.h>
#include "input_tcp.hpp"
#include "output_tcp.hpp"
#include "mrl.hpp"

#include "test_inout.hpp"

using namespace std;
using namespace mcat;

static void* test_in(void* data);
static void* test_out(void* data);
static sem_t *p_semaphore;

int main()
{
    pthread_t input_thread;
    pthread_t output_thread;
    cout << "Test the TCP classes...";
    cout.flush();
    int* return_in;
    int* return_out;
    p_semaphore = new sem_t;
    sem_init(p_semaphore, 0, 0);

    for (size_t i = 0; i < urls_count; ++i)
    {
        for(size_t j = 0; j < samples_count; ++j)
        {
            net_test_t net_test;
            net_test.url = urls[i];
            net_test.sample = &samples[j];
            // The input and the outputs are ready: launch the threads
            if(pthread_create(&output_thread, NULL, test_out, &net_test))
            {
                cerr << "Unable to launch the output thread" << endl;
                return 1;
            }

            if(pthread_create(&input_thread, NULL, test_in, &net_test))
            {
                cerr << "Unable to launch the input thread" << endl;
                return 1;
            }

            // Wait for the input and output thread
            pthread_join(output_thread, (void**)&return_out);
            pthread_join(input_thread,  (void**)&return_in);
            if (return_in != NULL || return_out != NULL)
            {
                cerr << "Error during the test" << endl;
                return 1;
            }
        }
    }

    sem_destroy(p_semaphore);
    delete p_semaphore;
    cout << "\t\t[done]" << endl;
    return 0;
}

static void* test_in(void* data)
{
    char big_buf[BUF_LEN + 2];
    char *buf = big_buf + 1;
    net_test_t* net_test = static_cast<net_test_t*>(data);
    const char* url = net_test->url;
    const sample_t* sample = net_test->sample;

    memset(big_buf, 0, sizeof(big_buf));

    sem_wait(p_semaphore);
    Mrl mrl(string("tcp://") + string(url));
    InputTCP input_udp(mrl);
    input_udp.read(buf, sample->len);

    if(big_buf[0] != '\0')
    {
        cerr << endl << "InputTCP::read(\"" << sample->in << "\", "
             << sample->len << ") failed "
            << "the program has written before the buffer"
            << endl;
        pthread_exit((void*)1);
    }

    if(buf[sample->len] != '\0')
    {
        cerr << endl << "InputTCP::read(\"" << sample->in << "\", "
             << sample->len << ") failed "
            << "the program has written after the buffer"
            << endl;
        pthread_exit((void*)1);
    }

    if(memcmp(buf, sample->out, sample->len))
    {
        cerr << endl << "InputTCP::read(\"" << sample->in << "\", "
            << sample->len << ") failed got `" << buf
            << "` instead of " << sample->out
            << endl;
        pthread_exit((void*)1);
    }
    return NULL;
}

static void* test_out(void* data)
{
    net_test_t* net_test = static_cast<net_test_t*>(data);
    const char* url = net_test->url;
    const sample_t* sample = net_test->sample;

    Mrl mrl(string("tcp://") + string(url));
    OutputTCP output_udp(mrl);
    sem_post(p_semaphore);

    output_udp.write(sample->in, sample->len);

    return NULL;
}

