#include <cstring>
#include <iostream>
#include <sstream>

#include "input_std.hpp"
#include "mrl.hpp"

#include "test_inout.hpp"

using namespace std;
using namespace mcat;

int main()
{
    char big_buf[BUF_LEN + 2];
    char* buf = big_buf +1;

    istream orig_cin(cin.rdbuf());
    stringstream ncin;
    streambuf* inbuf = ncin.rdbuf();

    cout << "Test the InputStd class...";
    cin.rdbuf(inbuf);
    Mrl mrl("");
    InputStd input_std(mrl);

    for(size_t i = 0; i < samples_count; ++i)
    {
        memset(big_buf, 0, sizeof(big_buf));
        ncin.write(samples[i].in, samples[i].len);
        input_std.read(buf, samples[i].len);

        if (big_buf[0] != '\0')
        {
            cerr << endl << "InputStd::read(\"" << samples[i].in << "\", "
                 << samples[i].len << ") failed "
                 << "the program has written before the buffer"
                 << endl;
            return 1;
        }

        if (buf[samples[i].len] != '\0')
        {
            cerr << endl << "InputStd::read(\"" << samples[i].in << "\", "
                 << samples[i].len << ") failed "
                 << "the program has written after the buffer"
                 << endl;
            return 1;
        }

        if (memcmp(buf, samples[i].out, samples[i].len))
        {
            cerr << endl << "InputStd::read(\"" << samples[i].in << "\", "
                 << samples[i].len << ") failed got " << buf
                 << "instead of " << samples[i].out
                 << endl;
            return 1;
        }
        ncin.clear();
    }

    cin.rdbuf(orig_cin.rdbuf());
    cout << "\t[done]" << endl;
}

