#ifndef OUTPUT_UDP_HPP
#define OUTPUT_UDP_HPP

#include <netinet/in.h>

#include "output.hpp"

namespace mcat
{

class OutputUDP : public Output
{
public:
    /**
     * Connection which opens an udp connection. Could be used for unicast and
     * multicast output udp stream
     * @param mrl: the MRL of the destination stream
     * @param broadcast: whether input broadcast is allowed
     */
    OutputUDP(Mrl &mrl, bool broadcast);

    /** Destructor */
    virtual ~OutputUDP();

    /**
     * Write to the destination
     * @param p_buffer: the buffer to write
     * @param ui_size: the size of the buffer to write
     * @return the size written to the destination
     */
    virtual int write(const char *p_buffer, ssize_t ui_size);

    /**
     * Get the protocol used to analyse the command line
     * @return the protocol
     */
    inline static const char* getProtocol()
    {
        return "udp";
    }

    /**
     * Get the usage as printed in the ./mc --help command
     * @return the usage
     */
    inline static const char* getUsage()
    {
        return "write to an udp stream, unicast or multicast";
    }

protected:
    /** Output socket */
    int i_sock;
    /** Structure containing the inet socket address */
    struct addrinfo* p_addr_info;
    /** ttl (used for multicast) */
    unsigned char ttl;
};

}

#endif // OUTPUT_UDP_HPP
