#ifndef MCAT_INPUT_STD_HPP
#define MCAT_INPUT_STD_HPP

#include "input.hpp"

namespace mcat
{

class InputStd : public Input
{
public:
    /**
     * Construtor that open the connection to the standard input
     * @param mrl: unused
     */
    InputStd(Mrl &mrl) : Input(mrl) { is_ready = true; }

    /** Destructor */
    virtual ~InputStd() {}

    /**
     * Read from the source
     * @param p_buffer: the buffer to fill
     * @param ui_size: the size of the buffer to read
     * @return the size read from the source
     */
    virtual int read(char *p_buffer, ssize_t ui_size);

    /**
     * Get the protocol used to analyse the command line
     * @return the protocol
     */
    inline static const char* getProtocol()
    {
        return "std";
    }

    /**
     * Get the usage as printed in the ./mc --help command
     * @return the usage
     */
    inline static const char* getUsage()
    {
        return "read from the standard input";
    }
};

};

#endif // MCAT_INPUT_STD_HPP
