#include <iostream>

#include "input_file.hpp"

using namespace mcat;

InputFile::InputFile(Mrl &mrl) : Input(mrl)
{
    m_src_file.open(mrl.getPath());
    if(!m_src_file.good())
        std::cerr << "Failed to open the file " << mrl.getPath()
                  << " for reading" << std::endl;
    else
        is_ready = true;
}

InputFile::~InputFile()
{
    m_src_file.close();
}

int InputFile::read(char *p_buffer, ssize_t ui_size)
{
    m_src_file.read(p_buffer, ui_size);
    return m_src_file.gcount();
}

