#include <cstring>
#include <iostream>
#include <sstream>

#include "output_std.hpp"
#include "mrl.hpp"

#include "test_inout.hpp"

using namespace std;
using namespace mcat;

int main()
{
    char buf[BUF_LEN];
    ostream orig_cout(cout.rdbuf());
    stringstream ncout;
    streambuf* outbuf = ncout.rdbuf();

    cout << "Test the OutputStd class...";
    cout.rdbuf(outbuf);
    Mrl mrl("");
    OutputStd output_std(mrl);

    for(size_t i = 0; i < samples_count; ++i)
    {
        ncout.clear();
        output_std.write(samples[i].in, samples[i].len);
        ncout.read(buf, samples[i].len);

        if (memcmp(buf, samples[i].out, samples[i].len))
        {
            cerr << endl << "OutputStd::read(\"" << samples[i].in << "\", "
                 << samples[i].len << ") failed got " << buf
                 << "instead of " << samples[i].out
                 << endl;
            return 1;
        }
        ncout.clear();
    }

    cout.rdbuf(orig_cout.rdbuf());
    cout << "\t[done]" << endl;
}

