#include <stdlib.h>
#include <iostream>

#include "ring_buffer.hpp"

using namespace mcat;

RingBuffer::RingBuffer(size_t buffer_size, unsigned int buffer_count)
{
    pthread_mutex_init(&m_lock, NULL);
    pthread_cond_init(&m_cond, NULL);

    m_buffer_size = buffer_size;
    m_buffer_count = buffer_count;

    for(unsigned int i = 0; i < buffer_count; i++)
        m_free_buffer.push(new Buffer(buffer_size));
}

RingBuffer::~RingBuffer()
{
    while(!m_buffer.empty())
    {
        delete m_buffer.front();
        m_buffer.pop();
    }
    while(!m_free_buffer.empty())
    {
        delete m_free_buffer.front();
        m_free_buffer.pop();
    }

    pthread_cond_destroy(&m_cond); 
    pthread_mutex_destroy(&m_lock);
}

const Buffer *RingBuffer::nextFull()
{
    const Buffer *p_buffer;
    pthread_mutex_lock(&m_lock);
    while(m_buffer.empty())
        pthread_cond_wait(&m_cond, &m_lock);    

    p_buffer = m_buffer.front();

    pthread_mutex_unlock(&m_lock);
    return p_buffer;
}

void RingBuffer::popFull()
{
    pthread_mutex_lock(&m_lock);
    Buffer *p_buffer = m_buffer.front();
    m_buffer.pop();
    m_free_buffer.push(p_buffer);
    pthread_cond_signal(&m_cond);
    pthread_mutex_unlock(&m_lock);
}

Buffer *RingBuffer::nextEmpty()
{
    Buffer *p_buffer;
    pthread_mutex_lock(&m_lock);
    while(m_free_buffer.empty())
        pthread_cond_wait(&m_cond, &m_lock);

    p_buffer = m_free_buffer.front();
    m_free_buffer.pop();
    
    pthread_mutex_unlock(&m_lock);
    return p_buffer;
}

void RingBuffer::pushFull(Buffer *p_buffer)
{
    pthread_mutex_lock(&m_lock);
    m_buffer.push(p_buffer);
    pthread_cond_signal(&m_cond);
    pthread_mutex_unlock(&m_lock);
}

