#include <iostream>
#include <cstdlib>
#include <cstring>

#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "common.hpp"
#include "macros.hpp"
#include "output_tcp.hpp"

using namespace mcat;

OutputTCP::OutputTCP(Mrl &mrl)
    : Output(mrl),
      i_cl_socket_fd(0)
{
    if(!getAddressInfo(mrl, AF_UNSPEC, SOCK_STREAM, &p_addr_info))
        return;

    // Create the socket
    i_socket_fd = socket(p_addr_info->ai_family == AF_INET ? PF_INET : PF_INET6,
                         SOCK_STREAM, IPPROTO_TCP);

    if(i_socket_fd < 0)
    {
        std::cerr << "Unable to create the socket" << std::endl;
        return;
    }

    int flag_true = 1;
    setsockopt(i_socket_fd, SOL_SOCKET, SO_REUSEADDR, &flag_true, sizeof(flag_true));

    if(bind(i_socket_fd, p_addr_info->ai_addr, p_addr_info->ai_addrlen) < 0)
    {
        std::cerr << "Unable to bind the socket" << std::endl;
        return;
    }

    if(listen(i_socket_fd, 0) < 0) //only 1 client
    {
        std::cerr << "Unable to listen to the socket" << std::endl;
        return;
    }

    // The output is now ready
    is_ready = true;
}

OutputTCP::~OutputTCP()
{
    // Close the socket
    if (i_cl_socket_fd > 0)
        close(i_cl_socket_fd);
    freeaddrinfo(p_addr_info);
}

int OutputTCP::write(const char* p_buffer, ssize_t ui_size)
{
    if (i_cl_socket_fd == 0)
    {
        //wait for connection and accept it
        socklen_t addrlen = p_addr_info->ai_addrlen;
        i_cl_socket_fd = accept(i_socket_fd, p_addr_info->ai_addr, &addrlen);
        if (i_cl_socket_fd < 0)
        {
            std::cerr << "Unable to accept the incoming connection" << std::endl;
            ///@todo do sth
        }

        //no longer used as we accept only one client
        close(i_socket_fd);
    }
    return send(i_cl_socket_fd, p_buffer, ui_size, 0);
}

