#ifndef MCAT_OUTPUT_STD_HPP
#define MCAT_OUTPUT_STD_HPP

#include "output.hpp"

namespace mcat
{

class OutputStd : public Output
{
public:
    /**
     * Construtor that open the connection to the destination stream
     * @param mrl: unused
     */
    OutputStd(Mrl &mrl) : Output(mrl) { is_ready = true; }

    /** Destructor */
    virtual ~OutputStd();

    /**
     * Write to the destination
     * @param p_buffer: the buffer to write
     * @param ui_size: the size of the buffer to write
     * @return the size writen to the destination
     */
    virtual int write(const char *p_buffer, ssize_t ui_size);

    /**
     * Get the protocol used to analyse the command line
     * @return the protocol
     */
    inline static const char* getProtocol()
    {
        return "std";
    }

    /**
     * Get the usage as printed in the ./mc --help command
     * @return the usage
     */
    inline static const char* getUsage()
    {
        return "write into the standard output";
    }
};

};

#endif // MCAT_OUTPUT_STD_HPP
