#ifndef MCAT_OUTPUT_FILE_HPP
#define MCAT_OUTPUT_FILE_HPP

#include <fstream>
#include "output.hpp"

namespace mcat
{

class OutputFile : public Output
{
public:
    /**
     * Construtor that open the connection to the destination stream
     * @param mrl: the MRL of the destination stream
     */
    OutputFile(Mrl &mrl);

    /** Destructor */
    virtual ~OutputFile();

    /**
     * Write to the destination
     * @param p_buffer: the buffer to write
     * @param ui_size: the size of the buffer to write
     * @return the size writen to the destination
     */
    virtual int write(const char *p_buffer, ssize_t ui_size);

    /**
     * Get the protocol used to analyse the command line
     * @return the protocol
     */
    inline static const char* getProtocol()
    {
        return "file";
    }

    /**
     * Get the usage as printed in the ./mc --help command
     * @return the usage
     */
    inline static const char* getUsage()
    {
        return "write into a file in the local system";
    }

protected:
    /** The file handler */
    std::ofstream m_dst_file;
};

};

#endif // MCAT_OUTPUT_FILE_HPP
