#include <cstdlib>
#include <iostream>

#include "output_file.hpp"

using namespace mcat;

OutputFile::OutputFile(Mrl &mrl) : Output(mrl)
{
    m_dst_file.open(mrl.getPath());
    if(!m_dst_file.good())
        std::cerr << "Failed to open the file " << mrl.getPath()
                  << " for writing" << std::endl;
    else
        is_ready = true;
}

OutputFile::~OutputFile()
{
    m_dst_file.close();
}

int OutputFile::write(const char *p_buffer, ssize_t ui_size)
{
    m_dst_file.write(p_buffer, ui_size);
    return 0;
}

