#ifndef MCAT_HPP
#define MCAT_HPP

#include <pthread.h>
#include <string>
#include <vector>
#include <ostream>

#include "input.hpp"
#include "mrl.hpp"
#include "output.hpp"
#include "ring_buffer.hpp"

namespace mcat
{

class Mcat
{
public:
    /**
     * Constructor
     * @param input: the input mrl
     * @param outputs: the output mrls
     * @param buffer_count: the number of buffers
     * @param buffer_size: the size of each buffer
     * @param broadcast: whether the broadcast is allowed
     */
    Mcat(std::string input, std::vector<std::string> outputs,
         unsigned int buffer_count, size_t buffer_size,
         bool broadcast = false);

    /** Destructor */
    ~Mcat();

    /**
     * Prints the usage to an output
     * @param stream destination stream
     */
    static void printUsage(std::ostream& stream);

protected:
    /** The input */
    Input *m_input;

    /** The input thread id */
    pthread_t m_input_thread;

    /** The outputs */
    std::vector<Output*> m_output;

    /** The output thread id */
    pthread_t m_output_thread;

    /** The ring buffer */
    RingBuffer *m_buffers;

    /** The size of each buffer */
    size_t m_buffer_size;

    /**
     * Launch the input thread
     * @param p_data: this pointer
     * @return NULL
     */
    static void *launch_input_thread(void* p_data);

    /** Run the input thread */
    void input_thread();

    /**
     * Launch the output thread
     * @param p_data: this pointer
     * @return NULL
     */
    static void *launch_output_thread(void* p_data);

    /** Run the output thread */
    void output_thread();
};

};

#endif // MCAT_HPP
