#ifndef MCAT_MACROS_HPP
#define MCAT_MACROS_HPP

#include <arpa/inet.h>
#include <netinet/in.h>

#ifndef IN_MULTICAST
    #warning defining IN_MULTICAST()
    //usage IN_MULTICAST(ntohl(sin_addr->s_addr))
    #define IN_MULTICAST(a) ((((uint32_t) (a)) & 0xf0000000) == 0xe0000000)
#endif

#ifndef IN6_IS_ADDR_MULTICAST
    #warning defining IN6_IS_ADDR_MULTICAST()
    //usage IN6_IS_ADDR_MULTICAST(&sin6_addr)
    #define IN6_IS_ADDR_MULTICAST(a) ((a)->s6_addr[0] == 0xff)
#endif

#ifndef IPV6_ADD_MEMBERSHIP
    #warning defining IPV6_ADD_MEMBERSHIP
    #ifdef IPV6_JOIN_GROUP
        #define IPV6_ADD_MEMBERSHIP IPV6_JOIN_GROUP
    #else
        #error IPV6_ADD_MEMBERSHIP not defined
    #endif
#endif

#ifndef __linux__ //close()
    #include <unistd.h>
#endif

#endif // MCAT_MACROS_HPP
