#ifndef MCAT_INPUT_FILE_HPP
#define MCAT_INPUT_FILE_HPP

#include <fstream>

#include "input.hpp"

namespace mcat
{

class InputFile : public Input
{
public:
    /**
     * Construtor that open the connection to the source stream
     * @param mrl: the MRL of the source stream
     */
    InputFile(Mrl &mrl);

    /** Destructor */
    virtual ~InputFile();

    /**
     * Read from the source
     * @param p_buffer: the buffer to fill
     * @param ui_size: the size of the buffer to read
     * @return the size read from the source
     */
    virtual int read(char *p_buffer, ssize_t ui_size);

    /**
     * Get the protocol used to analyse the command line
     * @return the protocol
     */
    inline static const char* getProtocol()
    {
        return "file";
    }

    /**
     * Get the usage as printed in the ./mc --help command
     * @return the usage
     */
    inline static const char* getUsage()
    {
        return "read from a file in the local system";
    }

protected:
    /** The file handler */
    std::ifstream m_src_file;
};

};

#endif // MCAT_INPUT_FILE_HPP
